//=============================================================================
// TestBlock, Deployed.
//=============================================================================
class LampBlockDeployed extends BlockDeployed;

var bool bOn;

function UpdateBlock()
{
 local int i, NumCharge;
 
 AnalyzeNeighbors();
 
 for(i=0; i<6; i++)
 {
  if (CurNeighbors[i] != None && CurNeighbors[i].bHasCharge)
  {
   NumCharge++;
  }
 }
 
 bOn = (NumCharge > 0);
 
 if (bOn)
 {
  Multiskins[0] = Texture'LampBlockOn0';
  Multiskins[1] = Texture'LampBlockOn1';
  Multiskins[2] = Texture'LampBlockOn2';
  Multiskins[3] = Texture'LampBlockOn3';
  Multiskins[4] = Texture'LampBlockOn4';
  Multiskins[5] = Texture'LampBlockOn5';
  Skin = Texture'LampBlockOn';
  LightRadius = 64;
 }
 if (!bOn)
 {
  Multiskins[0] = Texture'LampBlockOff0';
  Multiskins[1] = Texture'LampBlockOff1';
  Multiskins[2] = Texture'LampBlockOff2';
  Multiskins[3] = Texture'LampBlockOff3';
  Multiskins[4] = Texture'LampBlockOff4';
  Multiskins[5] = Texture'LampBlockOff5';
  Skin = Texture'LampBlockOff';
  LightRadius = 0;
 }
}

defaultproperties
{
     ChargeStrength=1
     LightType=LT_Steady
     LightBrightness=64
     LightSaturation=255
     LightRadius=0
     LightPeriod=32
     LightCone=128
     VolumeBrightness=64
}
